package com.hero.objects.modifiers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.objects.List;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Gestures extends Modifier {
	private static String xmlID = "GESTURES";

	public Gestures(Element root) {
		super(root, Gestures.xmlID);
	}

	@Override
	public ArrayList<Modifier> getAssignedModifiers() {
		ArrayList<Modifier> ret = super.getAssignedModifiers();
		if (!HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
			return ret;
		}
		if (getProgenitor() != null) {
			if ((HeroDesigner.getActiveHero() == null)
					|| HeroDesigner.getActiveHero().isLoading()) {
				return ret;
			}
			if (getProgenitor() instanceof List) {
				List l = (List) getProgenitor();
				for (GenericObject o : l.getObjects()) {
					if (o.getDuration().equals("INSTANT")
							&& (GenericObject.findObjectByID(o
									.getAssignedModifiers(), "EXTRATIME") == null)
							&& (GenericObject.findObjectByID(ret, "THROUGHOUT") != null)
							&& (GenericObject.findObjectByID(o
									.getAssignedModifiers(), "REGENEXTRATIME") == null)
							&& !o.getXMLID().equals("MINDCONTROL")
							&& !o.getXMLID().equals("MINDSCAN")
							&& !o.getXMLID().equals("MINDLINK")
							&& !o.getXMLID().equals("TELEPATHY")
							&& !o.getXMLID().equals("FORCEWALL")) {
						ret.remove(GenericObject.findObjectByID(ret,
								"THROUGHOUT"));
						return ret;
					}
				}
				return ret;
			}
			if (!getProgenitor().getDuration().equals("INSTANT")
					|| (GenericObject.findObjectByID(getProgenitor()
							.getAssignedModifiers(), "EXTRATIME") != null)
					|| (GenericObject.findObjectByID(getProgenitor()
							.getAssignedModifiers(), "REGENEXTRATIME") != null)
					|| getProgenitor().getXMLID().equals("MINDCONTROL")
					|| getProgenitor().getXMLID().equals("MINDSCAN")
					|| getProgenitor().getXMLID().equals("MINDLINK")
					|| getProgenitor().getXMLID().equals("TELEPATHY")
					|| getProgenitor().getXMLID().equals("FORCEWALL")) {
				return ret;
			}

			if (getProgenitor().getDuration().equals("INSTANT")
					&& (GenericObject.findObjectByID(getProgenitor()
							.getAssignedModifiers(), "EXTRATIME") == null)
					&& (GenericObject.findObjectByID(ret, "THROUGHOUT") != null)
					&& (GenericObject.findObjectByID(getProgenitor()
							.getAssignedModifiers(), "REGENEXTRATIME") == null)
					&& !getProgenitor().getXMLID().equals("MINDCONTROL")
					&& !getProgenitor().getXMLID().equals("MINDSCAN")
					&& !getProgenitor().getXMLID().equals("MINDLINK")
					&& !getProgenitor().getXMLID().equals("TELEPATHY")
					&& !getProgenitor().getXMLID().equals("FORCEWALL")) {
				ret.remove(GenericObject.findObjectByID(ret, "THROUGHOUT"));
			}
		}
		return ret;
	}

	@Override
	public ArrayList<Modifier> getAvailableModifiers() {
		ArrayList<Modifier> ret = (ArrayList<Modifier>) super
				.getAvailableModifiers().clone();
		if (!HeroDesigner.getInstance().getPrefs().isModifierIntelligenceOn()) {
			return ret;
		}
		if (getProgenitor() != null) {
			if ((HeroDesigner.getActiveHero() == null)
					|| HeroDesigner.getActiveHero().isLoading()) {
				return ret;
			}
			if (getProgenitor() instanceof List) {
				List l = (List) getProgenitor();
				for (GenericObject o : l.getObjects()) {
					if (o.getDuration().equals("INSTANT")
							&& (GenericObject.findObjectByID(o
									.getAssignedModifiers(), "EXTRATIME") == null)
							&& (GenericObject.findObjectByID(ret, "THROUGHOUT") != null)
							&& (GenericObject.findObjectByID(o
									.getAssignedModifiers(), "REGENEXTRATIME") == null)
							&& !o.getXMLID().equals("MINDCONTROL")
							&& !o.getXMLID().equals("MINDSCAN")
							&& !o.getXMLID().equals("MINDLINK")
							&& !o.getXMLID().equals("TELEPATHY")
							&& !o.getXMLID().equals("FORCEWALL")) {
						ret.remove(GenericObject.findObjectByID(ret,
								"THROUGHOUT"));
						return ret;
					}
				}
				return ret;
			}
			if (!getProgenitor().getDuration().equals("INSTANT")
					|| (GenericObject.findObjectByID(getProgenitor()
							.getAssignedModifiers(), "EXTRATIME") != null)
					|| (GenericObject.findObjectByID(getProgenitor()
							.getAssignedModifiers(), "REGENEXTRATIME") != null)
					|| getProgenitor().getXMLID().equals("MINDCONTROL")
					|| getProgenitor().getXMLID().equals("MINDSCAN")
					|| getProgenitor().getXMLID().equals("MINDLINK")
					|| getProgenitor().getXMLID().equals("TELEPATHY")
					|| getProgenitor().getXMLID().equals("FORCEWALL")) {
				return ret;
			}

			if (getProgenitor().getDuration().equals("INSTANT")
					&& (GenericObject.findObjectByID(getProgenitor()
							.getAssignedModifiers(), "EXTRATIME") == null)
					&& (GenericObject.findObjectByID(ret, "THROUGHOUT") != null)
					&& (GenericObject.findObjectByID(getProgenitor()
							.getAssignedModifiers(), "REGENEXTRATIME") == null)
					&& !getProgenitor().getXMLID().equals("MINDCONTROL")
					&& !getProgenitor().getXMLID().equals("MINDSCAN")
					&& !getProgenitor().getXMLID().equals("MINDLINK")
					&& !getProgenitor().getXMLID().equals("TELEPATHY")
					&& !getProgenitor().getXMLID().equals("FORCEWALL")) {
				ret.remove(GenericObject.findObjectByID(ret, "THROUGHOUT"));
			}
		}
		return ret;
	}
}